<?php

namespace YOOtheme;

return [
    'name' => 'panel',
    'title' => 'Panel',
    'group' => 'basic',
    'icon' => '${url:images/icon.svg}',
    'iconSmall' => '${url:images/iconSmall.svg}',
    'element' => true,
    'width' => 500,
    'defaults' => [
        'link_text' => 'Read more',
        'title_hover_style' => 'reset',
        'title_element' => 'h3',
        'title_align' => 'top',
        'title_grid_width' => '1-2',
        'title_grid_breakpoint' => 'm',
        'meta_style' => 'text-meta',
        'meta_align' => 'below-title',
        'meta_element' => 'div',
        'content_column_breakpoint' => 'm',
        'image_align' => 'top',
        'image_grid_width' => '1-2',
        'image_grid_breakpoint' => 'm',
        'image_svg_color' => 'emphasis',
        'link_style' => 'default',
        'margin_top' => 'default',
        'margin_bottom' => 'default',
    ],
    'placeholder' => [
        'props' => [
            'title' => 'Title',
            'meta' => '',
            'content' =>
                'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
            'image' => '',
            'video' => '',
            'icon' => '',
            'hover_image' => '',
            'hover_video' => '',
        ],
    ],
    'updates' => __DIR__ . '/updates.php',
    'templates' => [
        'render' => __DIR__ . '/templates/template.php',
        'content' => __DIR__ . '/templates/content.php',
    ],
    'transforms' => [
        'render' => function ($node) {
            /**
             * Auto-correct media rendering for dynamic content
             *
             * @var View $view
             */
            $view = app(View::class);

            foreach (['', 'hover_'] as $prefix) {
                if (
                    $node->props["{$prefix}image"] &&
                    $view->isVideo($node->props["{$prefix}image"])
                ) {
                    $node->props["{$prefix}video"] = $node->props["{$prefix}image"];
                    $node->props["{$prefix}image"] = null;
                } elseif (
                    $node->props["{$prefix}video"] &&
                    $view->isImage($node->props["{$prefix}video"])
                ) {
                    $node->props["{$prefix}image"] = $node->props["{$prefix}video"];
                    $node->props["{$prefix}video"] = null;
                }
            }

            // Don't render element if content fields are empty
            return $node->props['title'] != '' ||
                $node->props['meta'] != '' ||
                $node->props['content'] != '' ||
                $node->props['image'] ||
                $node->props['video'] ||
                $node->props['icon'];
        },
    ],
    'fields' => [
        'title' => [
            'label' => 'Title',
            'source' => true,
        ],
        'meta' => [
            'label' => 'Meta',
            'source' => true,
        ],
        'content' => [
            'label' => 'Content',
            'type' => 'editor',
            'source' => true,
        ],
        'image' => [
            'label' => 'Image',
            'type' => 'image',
            'source' => true,
            'show' => '!video',
            'altRef' => '%name%_alt',
        ],
        'video' => [
            'label' => 'Video',
            'type' => 'video',
            'source' => true,
            'show' => '!image',
        ],
        'image_alt' => [
            'label' => 'Image Alt',
            'source' => true,
            'show' => 'image && !video',
        ],
        'icon' => [
            'label' => 'Icon',
            'description' =>
                'Instead of using a custom image, you can click on the pencil to pick an icon from the icon library.',
            'type' => 'icon',
            'source' => true,
            'enable' => '!image && !video',
        ],
        'link' => '${builder.link}',
        'link_text' => [
            'label' => 'Link Text',
            'description' => 'Enter the text for the link.',
            'source' => true,
            'enable' => 'link',
        ],
        'link_aria_label' => [
            'label' => 'Link ARIA Label',
            'description' =>
                'Enter a descriptive text label to make it accessible if the link has no visible text.',
            'source' => true,
            'enable' => 'link',
        ],
        'hover_image' => [
            'label' => 'Hover Image',
            'description' => 'Select an optional image that appears on hover.',
            'type' => 'image',
            'source' => true,
            'show' => '!hover_video',
            'enable' => 'image || video',
        ],
        'hover_video' => [
            'label' => 'Hover Video',
            'description' => 'Select an optional video that appears on hover.',
            'type' => 'video',
            'source' => true,
            'show' => '!hover_image',
            'enable' => 'image || video',
        ],
        'panel_style' => [
            'label' => 'Style',
            'description' => 'Select one of the boxed card or tile styles or a blank panel.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Card Default' => 'card-default',
                'Card Primary' => 'card-primary',
                'Card Secondary' => 'card-secondary',
                'Card Hover' => 'card-hover',
                'Card Overlay' => 'card-overlay',
                'Tile Default' => 'tile-default',
                'Tile Muted' => 'tile-muted',
                'Tile Primary' => 'tile-primary',
                'Tile Secondary' => 'tile-secondary',
            ],
        ],
        'panel_link' => [
            'label' => 'Link',
            'description' =>
                'Link the whole panel if a link exists. Optionally, add a hover style.',
            'type' => 'checkbox',
            'text' => 'Link panel',
            'enable' => 'link',
        ],
        'panel_link_hover' => [
            'type' => 'checkbox',
            'text' => 'Add hover style',
            'enable' =>
                'link && panel_link && $match(panel_style, \'card-(default|primary|secondary|overlay)|tile-\')',
        ],
        'panel_padding' => [
            'label' => 'Padding',
            'description' => 'Set the padding.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Small' => 'small',
                'Default' => 'default',
                'Large' => 'large',
            ],
            'enable' =>
                'panel_style || (!panel_style && (image || video) && image_align != \'between\')',
        ],
        'panel_image_no_padding' => [
            'description' =>
                'Top, bottom, left or right aligned images can be attached to the panel edge. If the image is aligned to the left or right, it will also extend to cover the whole space.',
            'type' => 'checkbox',
            'text' => 'Align image without padding',
            'show' => 'panel_style',
            'enable' => '(image || video) && image_align != \'between\'',
        ],
        'height_expand' => [
            'label' => 'Height',
            'description' =>
                'Expand the height of the element to fill the available space in the column.',
            'type' => 'checkbox',
            'text' => 'Fill the available column space',
        ],
        'image_expand' => [
            'type' => 'checkbox',
            'text' => 'Expand image',
            'enable' => 'height_expand',
        ],
        'html_element' => '${builder.html_element}',
        'title_style' => [
            'label' => 'Style',
            'description' =>
                'Title styles differ in font-size but may also come with a predefined color, size and font.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Text Meta' => 'text-meta',
                'Text Lead' => 'text-lead',
                'Text Small' => 'text-small',
                'Text Large' => 'text-large',
                'Heading 3X-Large' => 'heading-3xlarge',
                'Heading 2X-Large' => 'heading-2xlarge',
                'Heading X-Large' => 'heading-xlarge',
                'Heading Large' => 'heading-large',
                'Heading Medium' => 'heading-medium',
                'Heading Small' => 'heading-small',
                'Heading H1' => 'h1',
                'Heading H2' => 'h2',
                'Heading H3' => 'h3',
                'Heading H4' => 'h4',
                'Heading H5' => 'h5',
                'Heading H6' => 'h6',
            ],
            'enable' => 'title',
        ],
        'title_link' => [
            'label' => 'Link',
            'description' => 'Link the title if a link exists.',
            'type' => 'checkbox',
            'text' => 'Link title',
            'enable' => 'title && link',
        ],
        'title_hover_style' => [
            'label' => 'Hover Style',
            'description' => 'Set the hover style for a linked title.',
            'type' => 'select',
            'options' => [
                'None' => 'reset',
                'Heading Link' => 'heading',
                'Default Link' => '',
            ],
            'enable' => 'title && link && (title_link || panel_link)',
        ],
        'title_decoration' => [
            'label' => 'Decoration',
            'description' =>
                'Decorate the title with a divider, bullet or a line that is vertically centered to the heading.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Divider' => 'divider',
                'Bullet' => 'bullet',
                'Line' => 'line',
            ],
            'enable' => 'title',
        ],
        'title_font_family' => [
            'label' => 'Font Family',
            'description' =>
                'Select an alternative font family. Mind that not all styles have different font families.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Default' => 'default',
                'Primary' => 'primary',
                'Secondary' => 'secondary',
                'Tertiary' => 'tertiary',
            ],
            'enable' => 'title',
        ],
        'title_color' => [
            'label' => 'Color',
            'description' =>
                'Select the text color. If the Background option is selected, styles that don\'t apply a background image use the primary color instead.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Muted' => 'muted',
                'Emphasis' => 'emphasis',
                'Primary' => 'primary',
                'Secondary' => 'secondary',
                'Success' => 'success',
                'Warning' => 'warning',
                'Danger' => 'danger',
                'Background' => 'background',
            ],
            'enable' => 'title',
        ],
        'title_element' => [
            'label' => 'HTML Element',
            'description' =>
                'Set the level for the section heading or give it no semantic meaning.',
            'type' => 'select',
            'options' => [
                'h1' => 'h1',
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
                'div' => 'div',
            ],
            'enable' => 'title',
        ],
        'title_align' => [
            'label' => 'Alignment',
            'description' => 'Align the title to the top or left in regards to the content.',
            'type' => 'select',
            'options' => [
                'Top' => 'top',
                'Left' => 'left',
            ],
            'enable' => 'title',
        ],
        'title_grid_width' => [
            'label' => 'Grid Width',
            'description' =>
                'Define the width of the title within the grid. Choose between percent and fixed widths or expand columns to the width of their content.',
            'type' => 'select',
            'options' => [
                'Auto' => 'auto',
                'Expand' => 'expand',
                '80%' => '4-5',
                '75%' => '3-4',
                '66%' => '2-3',
                '60%' => '3-5',
                '50%' => '1-2',
                '40%' => '2-5',
                '33%' => '1-3',
                '25%' => '1-4',
                '20%' => '1-5',
                'Small' => 'small',
                'Medium' => 'medium',
                'Large' => 'large',
                'X-Large' => 'xlarge',
                '2X-Large' => '2xlarge',
            ],
            'enable' => 'title && title_align == \'left\'',
        ],
        'title_grid_column_gap' => [
            'label' => 'Grid Column Gap',
            'description' => 'Set the size of the gap between the title and the content.',
            'type' => 'select',
            'options' => [
                'Small' => 'small',
                'Medium' => 'medium',
                'Default' => '',
                'Large' => 'large',
                'None' => 'collapse',
            ],
            'enable' => 'title && title_align == \'left\'',
        ],
        'title_grid_row_gap' => [
            'label' => 'Grid Row Gap',
            'description' => 'Set the size of the gap if the grid items stack.',
            'type' => 'select',
            'options' => [
                'Small' => 'small',
                'Medium' => 'medium',
                'Default' => '',
                'Large' => 'large',
                'None' => 'collapse',
            ],
            'enable' => 'title && title_align == \'left\'',
        ],
        'title_grid_breakpoint' => [
            'label' => 'Grid Breakpoint',
            'description' => 'Set the breakpoint from which grid items will stack.',
            'type' => 'select',
            'options' => [
                'Always' => '',
                'Small (Phone Landscape)' => 's',
                'Medium (Tablet Landscape)' => 'm',
                'Large (Desktop)' => 'l',
                'X-Large (Large Screens)' => 'xl',
            ],
            'enable' => 'title && title_align == \'left\'',
        ],
        'title_margin' => [
            'label' => 'Margin Top',
            'description' =>
                'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
            'type' => 'select',
            'options' => [
                'X-Small' => 'xsmall',
                'Small' => 'small',
                'Default' => '',
                'Medium' => 'medium',
                'Large' => 'large',
                'X-Large' => 'xlarge',
                'None' => 'remove',
            ],
            'enable' => 'title',
        ],
        'title_margin_auto' => [
            'label' => 'Margin Bottom',
            'type' => 'checkbox',
            'text' => 'Auto',
            'enable' => 'title',
        ],
        'meta_style' => [
            'label' => 'Style',
            'description' =>
                'Select a predefined meta text style, including color, size and font-family.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Text Meta' => 'text-meta',
                'Text Lead' => 'text-lead',
                'Text Small' => 'text-small',
                'Text Large' => 'text-large',
                'Heading 3X-Large' => 'heading-3xlarge',
                'Heading 2X-Large' => 'heading-2xlarge',
                'Heading X-Large' => 'heading-xlarge',
                'Heading Large' => 'heading-large',
                'Heading Medium' => 'heading-medium',
                'Heading Small' => 'heading-small',
                'Heading H1' => 'h1',
                'Heading H2' => 'h2',
                'Heading H3' => 'h3',
                'Heading H4' => 'h4',
                'Heading H5' => 'h5',
                'Heading H6' => 'h6',
            ],
            'enable' => 'meta',
        ],
        'meta_color' => [
            'label' => 'Color',
            'description' => 'Select the text color.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Muted' => 'muted',
                'Emphasis' => 'emphasis',
                'Primary' => 'primary',
                'Secondary' => 'secondary',
                'Success' => 'success',
                'Warning' => 'warning',
                'Danger' => 'danger',
            ],
            'enable' => 'meta',
        ],
        'meta_align' => [
            'label' => 'Alignment',
            'description' => 'Align the meta text.',
            'type' => 'select',
            'options' => [
                'Above Title' => 'above-title',
                'Below Title' => 'below-title',
                'Above Content' => 'above-content',
                'Below Content' => 'below-content',
            ],
            'enable' => 'meta',
        ],
        'meta_element' => [
            'label' => 'HTML Element',
            'description' =>
                'Set the level for the section heading or give it no semantic meaning.',
            'type' => 'select',
            'options' => [
                'h1' => 'h1',
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
                'div' => 'div',
            ],
            'enable' => 'meta',
        ],
        'meta_margin' => [
            'label' => 'Margin Top',
            'description' =>
                'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
            'type' => 'select',
            'options' => [
                'X-Small' => 'xsmall',
                'Small' => 'small',
                'Default' => '',
                'Medium' => 'medium',
                'Large' => 'large',
                'X-Large' => 'xlarge',
                'None' => 'remove',
            ],
            'enable' => 'meta',
        ],
        'meta_margin_auto' => [
            'label' => 'Margin Bottom',
            'type' => 'checkbox',
            'text' => 'Auto',
            'enable' => 'meta',
        ],
        'content_style' => [
            'label' => 'Style',
            'description' =>
                'Select a predefined text style, including color, size and font-family.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Text Meta' => 'text-meta',
                'Text Lead' => 'text-lead',
                'Text Small' => 'text-small',
                'Text Large' => 'text-large',
                'Heading 3X-Large' => 'heading-3xlarge',
                'Heading 2X-Large' => 'heading-2xlarge',
                'Heading X-Large' => 'heading-xlarge',
                'Heading Large' => 'heading-large',
                'Heading Medium' => 'heading-medium',
                'Heading Small' => 'heading-small',
                'Heading H1' => 'h1',
                'Heading H2' => 'h2',
                'Heading H3' => 'h3',
                'Heading H4' => 'h4',
                'Heading H5' => 'h5',
                'Heading H6' => 'h6',
            ],
            'enable' => 'content',
        ],
        'content_align' => [
            'label' => 'Alignment',
            'type' => 'checkbox',
            'text' => 'Force left alignment',
            'enable' => 'content',
        ],
        'content_dropcap' => [
            'label' => 'Drop Cap',
            'description' => 'Display the first letter of the paragraph as a large initial.',
            'type' => 'checkbox',
            'text' => 'Enable drop cap',
            'enable' => 'content',
        ],
        'content_column' => [
            'label' => 'Columns',
            'description' => 'Set the number of text columns.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Halves' => '1-2',
                'Thirds' => '1-3',
                'Quarters' => '1-4',
                'Fifths' => '1-5',
                'Sixths' => '1-6',
            ],
            'enable' => 'content',
        ],
        'content_column_divider' => [
            'description' => 'Show a divider between text columns.',
            'type' => 'checkbox',
            'text' => 'Show dividers',
            'enable' => 'content && content_column',
        ],
        'content_column_breakpoint' => [
            'label' => 'Columns Breakpoint',
            'description' => 'Set the device width from which the text columns should apply.',
            'type' => 'select',
            'options' => [
                'Always' => '',
                'Small (Phone Landscape)' => 's',
                'Medium (Tablet Landscape)' => 'm',
                'Large (Desktop)' => 'l',
                'X-Large (Large Screens)' => 'xl',
            ],
            'enable' => 'content && content_column',
        ],
        'content_margin' => [
            'label' => 'Margin Top',
            'description' =>
                'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
            'type' => 'select',
            'options' => [
                'X-Small' => 'xsmall',
                'Small' => 'small',
                'Default' => '',
                'Medium' => 'medium',
                'Large' => 'large',
                'X-Large' => 'xlarge',
                'None' => 'remove',
            ],
            'enable' => 'content',
        ],
        'content_margin_auto' => [
            'label' => 'Margin Bottom',
            'type' => 'checkbox',
            'text' => 'Auto',
            'enable' => 'content',
        ],
        'image_width' => [
            'type' => 'number',
            'attrs' => [
                'placeholder' => 'auto',
            ],
            'enable' => 'image || video || icon',
        ],
        'image_height' => [
            'type' => 'number',
            'attrs' => [
                'placeholder' => 'auto',
            ],
            'enable' => 'image || video || icon',
        ],
        'image_focal_point' => [
            'label' => 'Focal Point',
            'description' => 'Set a focal point to control cropping.',
            'type' => 'select',
            'options' => [
                'Top Left' => 'top-left',
                'Top Center' => 'top-center',
                'Top Right' => 'top-right',
                'Center Left' => 'center-left',
                'Center Center' => '',
                'Center Right' => 'center-right',
                'Bottom Left' => 'bottom-left',
                'Bottom Center' => 'bottom-center',
                'Bottom Right' => 'bottom-right',
            ],
            'source' => true,
            'enable' => 'image || video',
        ],
        'image_loading' => [
            'label' => 'Loading',
            'description' =>
                'By default, images are loaded lazy. Enable eager loading for images in the initial viewport.',
            'type' => 'checkbox',
            'text' => 'Load image eagerly',
            'enable' => 'image || video',
        ],
        'image_border' => [
            'label' => 'Border',
            'description' => 'Select the image border style.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Rounded' => 'rounded',
                'Circle' => 'circle',
                'Pill' => 'pill',
            ],
            'enable' =>
                '(image || video) && (!panel_style || (panel_style && (!panel_image_no_padding || image_align == \'between\')))',
        ],
        'image_box_shadow' => [
            'label' => 'Box Shadow',
            'description' => 'Select the image box shadow size.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Small' => 'small',
                'Medium' => 'medium',
                'Large' => 'large',
                'X-Large' => 'xlarge',
            ],
            'enable' => '(image || video) && !panel_style',
        ],
        'image_box_decoration' => [
            'label' => 'Box Decoration',
            'description' => 'Select the image box decoration style.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Default' => 'default',
                'Primary' => 'primary',
                'Secondary' => 'secondary',
                'Floating Shadow' => 'shadow',
                'Mask' => 'mask',
            ],
            'enable' => '(image || video) && !panel_style',
        ],
        'image_box_decoration_inverse' => [
            'type' => 'checkbox',
            'text' => 'Inverse style',
            'enable' =>
                '(image || video) && !panel_style && $match(image_box_decoration, \'^(default|primary|secondary)$\')',
        ],
        'image_link' => [
            'label' => 'Link',
            'description' => 'Link the image if a link exists.',
            'type' => 'checkbox',
            'text' => 'Link image',
            'enable' => '(image || video) && link',
        ],
        'image_transition' => [
            'label' => 'Hover Transition',
            'description' =>
                'Set the hover transition for a linked image. If the hover image is set, the transition takes place between the two images. If <i>None</i> is selected, the hover image fades in.',
            'type' => 'select',
            'options' => [
                'None (Fade if hover image)' => '',
                'Scale Up' => 'scale-up',
                'Scale Down' => 'scale-down',
            ],
            'enable' => '(image || video) && (link && (image_link || panel_link))',
        ],
        'image_transition_border' => [
            'type' => 'checkbox',
            'text' => 'Border',
            'enable' => '(image || video) && link && (image_link || panel_link)',
        ],
        'image_hover_box_shadow' => [
            'label' => 'Hover Box Shadow',
            'description' => 'Select the image box shadow size on hover.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Small' => 'small',
                'Medium' => 'medium',
                'Large' => 'large',
                'X-Large' => 'xlarge',
            ],
            'enable' => '(image || video) && link && !panel_style && (image_link || panel_link)',
        ],
        'image_align' => [
            'label' => 'Alignment',
            'description' =>
                'Align the image to the top, left, right or place it between the title and the content.',
            'type' => 'select',
            'options' => [
                'Top' => 'top',
                'Bottom' => 'bottom',
                'Left' => 'left',
                'Right' => 'right',
                'Between' => 'between',
            ],
            'enable' => 'image || video || icon',
        ],
        'image_grid_width' => [
            'label' => 'Grid Width',
            'description' =>
                'Define the width of the image within the grid. Choose between percent and fixed widths or expand columns to the width of their content.',
            'type' => 'select',
            'options' => [
                'Auto' => 'auto',
                '80%' => '4-5',
                '75%' => '3-4',
                '66%' => '2-3',
                '60%' => '3-5',
                '50%' => '1-2',
                '40%' => '2-5',
                '33%' => '1-3',
                '25%' => '1-4',
                '20%' => '1-5',
                'Small' => 'small',
                'Medium' => 'medium',
                'Large' => 'large',
                'X-Large' => 'xlarge',
                '2X-Large' => '2xlarge',
            ],
            'enable' => '(image || video || icon) && $match(image_align, \'left|right\')',
        ],
        'image_grid_column_gap' => [
            'label' => 'Grid Column Gap',
            'description' => 'Set the size of the gap between the image and the content.',
            'type' => 'select',
            'options' => [
                'Small' => 'small',
                'Medium' => 'medium',
                'Default' => '',
                'Large' => 'large',
                'None' => 'collapse',
            ],
            'enable' =>
                '(image || video || icon) && $match(image_align, \'left|right\') && !(panel_image_no_padding && panel_style)',
        ],
        'image_grid_row_gap' => [
            'label' => 'Grid Row Gap',
            'description' => 'Set the size of the gap if the grid items stack.',
            'type' => 'select',
            'options' => [
                'Small' => 'small',
                'Medium' => 'medium',
                'Default' => '',
                'Large' => 'large',
                'None' => 'collapse',
            ],
            'enable' =>
                '(image || video || icon) && $match(image_align, \'left|right\') && !(panel_image_no_padding && panel_style)',
        ],
        'image_grid_breakpoint' => [
            'label' => 'Grid Breakpoint',
            'description' => 'Set the breakpoint from which grid items will stack.',
            'type' => 'select',
            'options' => [
                'Always' => '',
                'Small (Phone Landscape)' => 's',
                'Medium (Tablet Landscape)' => 'm',
                'Large (Desktop)' => 'l',
                'X-Large (Large Screens)' => 'xl',
            ],
            'enable' => '(image || video || icon) && $match(image_align, \'left|right\')',
        ],
        'image_vertical_align' => [
            'label' => 'Vertical Alignment',
            'description' => 'Vertically center grid items.',
            'type' => 'checkbox',
            'text' => 'Center',
            'enable' => '(image || video || icon) && $match(image_align, \'left|right\')',
        ],
        'image_margin' => [
            'label' => 'Margin Top',
            'description' =>
                'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
            'type' => 'select',
            'options' => [
                'X-Small' => 'xsmall',
                'Small' => 'small',
                'Default' => '',
                'Medium' => 'medium',
                'Large' => 'large',
                'X-Large' => 'xlarge',
                'None' => 'remove',
            ],
            'enable' =>
                '(image || video || icon) && (image_align == \'between\' || (image_align == \'bottom\' && !(panel_style && panel_image_no_padding)))',
        ],
        'image_svg_inline' => [
            'label' => 'Inline SVG',
            'description' =>
                'Inject SVG images into the page markup so that they can easily be styled with CSS.',
            'type' => 'checkbox',
            'text' => 'Make SVG stylable with CSS',
            'enable' => 'image',
        ],
        'image_svg_animate' => [
            'type' => 'checkbox',
            'text' => 'Animate strokes',
            'enable' => 'image && image_svg_inline',
        ],
        'image_svg_color' => [
            'label' => 'Icon/SVG Color',
            'description' =>
                'Select the SVG color. It will only apply to supported elements defined in the SVG.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Muted' => 'muted',
                'Emphasis' => 'emphasis',
                'Primary' => 'primary',
                'Secondary' => 'secondary',
                'Success' => 'success',
                'Warning' => 'warning',
                'Danger' => 'danger',
            ],
            'enable' => 'image || icon',
        ],
        'image_text_color' => [
            'label' => 'Text Color',
            'description' =>
                'Set light or dark color mode for text, buttons and controls if a sticky transparent navbar is displayed above.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Light' => 'light',
                'Dark' => 'dark',
            ],
            'source' => true,
            'enable' => 'image || video',
        ],
        'video_autoplay' => [
            'label' => 'Video Autoplay',
            'description' =>
                'Enable autoplay immediately, start as soon as the video enters the viewport or only on hover.',
            'type' => 'select',
            'options' => [
                'On' => '',
                'Inview' => 'inview',
                'Hover' => 'hover',
            ],
            'enable' => 'video',
        ],
        'video_autoplay_restart' => [
            'type' => 'checkbox',
            'text' => 'Restart from beginning',
            'enable' => 'video && video_autoplay',
        ],
        'hover_image_focal_point' => [
            'label' => 'Focal Point',
            'description' => 'Set a focal point to control cropping.',
            'type' => 'select',
            'options' => [
                'Top Left' => 'top-left',
                'Top Center' => 'top-center',
                'Top Right' => 'top-right',
                'Center Left' => 'center-left',
                'Center Center' => '',
                'Center Right' => 'center-right',
                'Bottom Left' => 'bottom-left',
                'Bottom Center' => 'bottom-center',
                'Bottom Right' => 'bottom-right',
            ],
            'source' => true,
        ],
        'link_target' => [
            'label' => 'Attributes',
            'description'  => 'Optionally, open the link in a new window, treat it as download, don\'t endorse the linked page or don\'t include the referrer header.',
            'type' => 'checkbox',
            'text' => 'Open in a new window',
            'enable' => 'link'
        ],
        'link_download' => [
            'type' => 'checkbox',
            'text' => 'Download',
            'enable' => 'link'
        ],
        'link_rel_nofollow' => [
            'type' => 'checkbox',
            'text' => 'Nofollow',
            'enable' => 'link'
        ],
        'link_rel_noreferrer' => [
            'type' => 'checkbox',
            'text' => 'Noreferrer',
            'enable' => 'link'
        ],
        'link_style' => [
            'label' => 'Style',
            'description' => 'Set the link style.',
            'type' => 'select',
            'options' => [
                'Button Default' => 'default',
                'Button Primary' => 'primary',
                'Button Secondary' => 'secondary',
                'Button Danger' => 'danger',
                'Button Text' => 'text',
                'Link' => '',
                'Link Muted' => 'link-muted',
                'Link Text' => 'link-text',
            ],
            'enable' => 'link && link_text',
        ],
        'link_size' => [
            'label' => 'Button Size',
            'description' => 'Set the button size.',
            'type' => 'select',
            'options' => [
                'Small' => 'small',
                'Default' => '',
                'Large' => 'large',
            ],
            'enable' =>
                'link && link_text && link_style && !$match(link_style, \'link-(muted|text)\')',
        ],
        'link_fullwidth' => [
            'type' => 'checkbox',
            'text' => 'Full width button',
            'enable' =>
                'link && link_text && link_style && !$match(link_style, \'link-(muted|text)\')',
        ],
        'link_margin' => [
            'label' => 'Margin Top',
            'description' =>
                'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
            'type' => 'select',
            'options' => [
                'X-Small' => 'xsmall',
                'Small' => 'small',
                'Default' => '',
                'Medium' => 'medium',
                'Large' => 'large',
                'X-Large' => 'xlarge',
                'None' => 'remove',
            ],
            'enable' => 'link && link_text',
        ],
        'position' => '${builder.position}',
        'position_left' => '${builder.position_left}',
        'position_right' => '${builder.position_right}',
        'position_top' => '${builder.position_top}',
        'position_bottom' => '${builder.position_bottom}',
        'position_z_index' => '${builder.position_z_index}',
        'blend' => '${builder.blend}',
        'margin_top' => '${builder.margin_top}',
        'margin_bottom' => '${builder.margin_bottom}',
        'maxwidth' => '${builder.maxwidth}',
        'maxwidth_breakpoint' => '${builder.maxwidth_breakpoint}',
        'block_align' => '${builder.block_align}',
        'block_align_breakpoint' => '${builder.block_align_breakpoint}',
        'block_align_fallback' => '${builder.block_align_fallback}',
        'text_align' => '${builder.text_align_justify}',
        'text_align_breakpoint' => '${builder.text_align_breakpoint}',
        'text_align_fallback' => '${builder.text_align_justify_fallback}',
        'animation' => '${builder.animation}',
        '_parallax_button' => '${builder._parallax_button}',
        'visibility' => '${builder.visibility}',
        'name' => '${builder.name}',
        'status' => '${builder.status}',
        'source' => '${builder.source}',
        'id' => '${builder.id}',
        'class' => '${builder.cls}',
        'attributes' => '${builder.attrs}',
        'css' => [
            'label' => 'CSS',
            'description' =>
                'Enter your own custom CSS. The following selectors will be prefixed automatically for this element: <code>.el-element</code>, <code>.el-title</code>, <code>.el-meta</code>, <code>.el-content</code>, <code>.el-image</code>, <code>.el-link</code>, <code>.el-hover-image</code>',
            'type' => 'editor',
            'editor' => 'code',
            'mode' => 'css',
            'attrs' => [
                'debounce' => 500,
                'hints' => [
                    '.el-element',
                    '.el-title',
                    '.el-meta',
                    '.el-content',
                    '.el-image',
                    '.el-link',
                    '.el-hover-image',
                ],
            ],
            'source' => true,
        ],
        'transform' => '${builder.transform}',
    ],
    'fieldset' => [
        'default' => [
            'type' => 'tabs',
            'fields' => [
                [
                    'title' => 'Content',
                    'fields' => [
                        'title',
                        'meta',
                        'content',
                        'image',
                        'video',
                        'image_alt',
                        'icon',
                        'link',
                        'link_text',
                        'link_aria_label',
                        'hover_image',
                        'hover_video',
                    ],
                ],
                [
                    'title' => 'Settings',
                    'fields' => [
                        [
                            'label' => 'Panel',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => [
                                'panel_style',
                                'panel_link',
                                'panel_link_hover',
                                'panel_padding',
                                'panel_image_no_padding',
                                'height_expand',
                                'image_expand',
                                'html_element',
                            ],
                        ],
                        [
                            'label' => 'Title',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => [
                                'title_style',
                                'title_link',
                                'title_hover_style',
                                'title_decoration',
                                'title_font_family',
                                'title_color',
                                'title_element',
                                'title_align',
                                'title_grid_width',
                                'title_grid_column_gap',
                                'title_grid_row_gap',
                                'title_grid_breakpoint',
                                'title_margin',
                                'title_margin_auto',
                            ],
                        ],
                        [
                            'label' => 'Meta',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => [
                                'meta_style',
                                'meta_color',
                                'meta_align',
                                'meta_element',
                                'meta_margin',
                                'meta_margin_auto',
                            ],
                        ],
                        [
                            'label' => 'Content',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => [
                                'content_style',
                                'content_align',
                                'content_dropcap',
                                'content_column',
                                'content_column_divider',
                                'content_column_breakpoint',
                                'content_margin',
                                'content_margin_auto',
                            ],
                        ],
                        [
                            'label' => 'Image',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => [
                                [
                                    'label' => 'Width/Height',
                                    'description' =>
                                        'Setting just one value preserves the original proportions. The image will be resized and cropped automatically, and where possible, high resolution images will be auto-generated.',
                                    'type' => 'grid',
                                    'width' => '1-2',
                                    'fields' => ['image_width', 'image_height'],
                                ],
                                'image_focal_point',
                                'image_loading',
                                'image_border',
                                'image_box_shadow',
                                'image_box_decoration',
                                'image_box_decoration_inverse',
                                'image_link',
                                'image_transition',
                                'image_transition_border',
                                'image_hover_box_shadow',
                                'image_align',
                                'image_grid_width',
                                'image_grid_column_gap',
                                'image_grid_row_gap',
                                'image_grid_breakpoint',
                                'image_vertical_align',
                                'image_margin',
                                'image_svg_inline',
                                'image_svg_animate',
                                'image_svg_color',
                                'image_text_color',
                                'video_autoplay',
                                'video_autoplay_restart',
                            ],
                        ],
                        [
                            'label' => 'Hover Image',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => ['hover_image_focal_point'],
                        ],
                        [
                            'label' => 'Link',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => [
                                'link_target',
                                'link_download',
                                'link_rel_nofollow',
                                'link_rel_noreferrer',
                                'link_style',
                                'link_size',
                                'link_fullwidth',
                                'link_margin',
                            ],
                        ],
                        [
                            'label' => 'General',
                            'type' => 'group',
                            'fields' => [
                                'position',
                                'position_left',
                                'position_right',
                                'position_top',
                                'position_bottom',
                                'position_z_index',
                                'blend',
                                'margin_top',
                                'margin_bottom',
                                'maxwidth',
                                'maxwidth_breakpoint',
                                'block_align',
                                'block_align_breakpoint',
                                'block_align_fallback',
                                'text_align',
                                'text_align_breakpoint',
                                'text_align_fallback',
                                'animation',
                                '_parallax_button',
                                'visibility',
                            ],
                        ],
                    ],
                ],
                '${builder.advanced}',
            ],
        ],
    ],
];
